let predicate fn opt = Option.(to_list @@ map fn opt)

let authored query_string =
  let q = Person.Set.of_query @@ String_set.query query_string in
  fun n -> Person.Set.predicate q n.Text.authors

let ided query_string =
	fun n -> n.Text.id = query_string

let keyworded query_string =
  let q = String_set.query query_string in
  fun n -> String_set.(predicate q (Text.set "Keywords" n))

let topics query_string =
  let q = String_set.query query_string in
  fun n -> String_set.(predicate q (Text.set "Topics" n))
