open Logarion
module FS = File_store
module A = Archive

let print r order_opt reverse_opt number_opt authors_opt topics_opt id_opt =
	let predicates = if id_opt <> "" then [ A.ided id_opt ] else []
		@ A.predicate A.authored authors_opt
		@ A.predicate A.topics topics_opt in
	let predicate text = List.fold_left (fun a e -> a && e text) true predicates in
	let pager = try Sys.getenv "PAGER" with Not_found -> "less" in
	let print_text acc (_t, fnames) = Printf.sprintf "%s %s" acc (List.hd fnames) in
	let paths = match order_opt with
	| false -> FS.fold ~r ~predicate print_text ""
	| true ->
		let order = match reverse_opt with true -> FS.newest | false -> FS.oldest in
		match number_opt with
		| Some number -> FS.fold ~r ~predicate ~order ~number print_text ""
		| None -> FS.fold ~r ~predicate ~order print_text ""
	in if paths = "" then ()
	else (ignore @@ Sys.command @@ Printf.sprintf "%s %s" pager paths)
	

open Cmdliner
let term =
	let id = Arg.(value & pos 0 string "" & info [] ~docv:"text ID") in
	let recurse = Arg.(value & flag & info ["R"] ~doc:"recurse, include subdirs") in
	let reverse = Arg.(value & flag & info ["r"] ~doc:"reverse order") in
	let time   = Arg.(value & flag & info ["t"] ~doc:"sort by time, newest first") in
	let number = Arg.(value & opt (some int) None & info ["n"]
		~docv:"number" ~doc:"number of entries to list") in
	let authed = Arg.(value & opt (some string) None & info ["authored"]
		~docv:"comma-separated names" ~doc:"texts by authors") in
	let topics = Arg.(value & opt (some string) None & info ["topics"]
		~docv:"comma-separated topics" ~doc:"texts with topics") in
	Term.(const print $ recurse $ time $ reverse $ number $ authed $ topics $ id),
	Term.info "read" ~doc:"list texts" ~man:[ `S "DESCRIPTION";
		`P "List header information for current directory. If -R is used, list header
		information for texts found in subdirectories too, along with their filepaths" ]
