open Kosuzu

let unfile files =
  let dirs, files = File_store.split_filetypes files in
  let unlink dir file = try Unix.unlink (Filename.concat dir file) with
                          Unix.(Unix_error(ENOENT,_,_))-> () in
  List.iter (fun d -> List.iter (unlink d) files) dirs

open Cmdliner
let files = Arg.(value & pos_all string [] & info [] ~docv: "Text filenames and subdirectories")

let unfile_t = Term.(const unfile $ files)

let cmd =
  let doc = "Unfile texts from subdirectories" in
  let man = [
      `S Manpage.s_description;
      `P "Unfile texts in parameter from directories in parameter, by removing hardlinks" ]
  in
  let info = Cmd.info "unfile" ~doc ~man in
  Cmd.v info unfile_t
