open Cmdliner

let subs = [
    Authors.cmd;
    Convert.cmd;
    Edit.cmd;
    File.cmd;
    Index.cmd;
    Last.cmd;
    Listing.cmd;
    New.cmd;
    Peers.cmd;
    Pull.cmd;
    Recent.cmd;
    Topics.cmd;
    Unfile.cmd;
  ]

let default_cmd = Term.(ret (const (`Help (`Pager, None))))

let txt =
  let doc = "Discover, collect and exchange texts" in
  let man = [
      `S Manpage.s_authors;
      `P "orbifx <mailto:fox@orbitalfox.eu>";
      `P "Izuru Yakumo <mailto:yakumo.izuru@chaotic.ninja>";
      `S Manpage.s_bugs;
      `P "Please report them at <mailto:kosuzu-dev@chaotic.ninja>";
      `S Manpage.s_see_also;
      `P "This program is named after Kosuzu Motoori from Touhou Suzunaan: Forbidden Scrollery";
      `P "https://en.touhouwiki.net/wiki/Forbidden_Scrollery" ]
  in
  Cmd.group (Cmd.info "txt" ~version:"%%VERSION%%" ~doc ~man) ~default:default_cmd subs

let main () = exit (Cmd.eval txt)
let () = main ()
