open Kosuzu
open Cmdliner

let new_txt title topics_opt =
	let kv = Kosuzu.File_store.of_kv_file () in
	let authors = Person.Set.of_string (try Kosuzu.Store.KV.find "Authors" kv
		with Not_found -> Sys.getenv "USER") in
	let text = { (Text.blank ()) with title; authors } in
	let text = try Text.with_str_set text "Topics" (Option.get topics_opt) with _->text in
	match File_store.with_text text with
	| Error s -> prerr_endline s
	| Ok (filepath, _note) ->
		print_endline filepath

let title = Arg.(value & pos 0 string "" & info [] ~docv: "title" ~doc: "Title for new article")
let topics = Arg.(value & opt (some string) None & info ["t"; "topics"] ~docv: "Comma-separated topics" ~doc: "Topics for new article")

let new_t = Term.(const new_txt $ title $ topics)

let cmd =
  let doc = "Create a new article" in
  let man = [
      `S Manpage.s_description;
      `P "Create a new article";
      `S Manpage.s_environment;
      `P "USER - The login name of the user, used if the Authors field is blank" ]
  in
  let info = Cmd.info "new" ~doc ~man in
  Cmd.v info new_t
