open Kosuzu

let last a ((t,_) as pair) = match a with
	| None -> Some pair
	| Some (t', _) as pair' ->
		if Text.newest t t' > 0 then Some pair else pair'

let last_mine a ((t, _) as pair) =
	let name = Person.Set.of_string (Sys.getenv "USER") in
	let open Text in
	match a with
	| None -> if Person.Set.subset name t.authors then Some pair else None
	| Some (t', _) as pair' ->
		if Text.newest t t' > 0 && Person.Set.subset name t'.authors
		then Some pair else pair'

let last search_mine =
	let filter = if search_mine then last_mine else last in
	match File_store.fold filter None with
	| None -> ()
	| Some (_, f) -> List.iter print_endline f

open Cmdliner

let mine = Arg.(value & flag & info ["mine"] ~doc: "Last text authored by me")
let last_t = Term.(const last $ mine)

let cmd =
  let doc = "Most recent text" in
  let man = [
      `S Manpage.s_description;
      `P "Print the filename of most recent text" ]
  in
  let info = Cmd.info "last" ~doc ~man in
  Cmd.v info last_t
