open Kosuzu
let file files =
	let dirs, files = File_store.split_filetypes files in
	let _link_as_named dir file = Unix.link file (Filename.concat dir file) in
	let link_with_id dir file =
		match File_store.to_text file with Error s -> prerr_endline s
		| Ok t -> Unix.link file (Filename.concat dir (Text.short_id t^".txt")) in
	let link = link_with_id in
	List.iter (fun d -> List.iter (link d) files) dirs

open Cmdliner
let files = Arg.(value & pos_all string [] & info [] ~docv: "Text filenames and subdirectories")
let file_t = Term.(const file $ files)

let cmd =
  let doc = "File texts in subdirectories" in
  let man = [
      `S Manpage.s_description;
      `P "Files all texts in parameter in every directory in parameter, using hardlinks";
      `P "Use it to create sub-repositories for sharing or converting" ]
  in
  let info = Cmd.info "file" ~doc ~man in
  Cmd.v info file_t
