open Logarion
let topics r authors_opt =
	let predicates = Archive.(predicate authored authors_opt) in
	let predicate text = List.fold_left (fun a e -> a && e text) true predicates in
	let topic_union a (e, _) = String_set.union a (Text.set "topics" e) in
	let s = File_store.fold ~r ~predicate topic_union String_set.empty in
	print_endline @@ String_set.to_string s

open Cmdliner
let recurse = Arg.(value & flag & info ["R"] ~doc: "Include texts in subdirectories")
let authed = Arg.(value & opt (some string) None & info ["authored"] ~docv: "Comma-separated authors" ~doc: "Topics by authors")
let topics_t = Term.(const topics $ recurse $ authed)

let cmd =
  let doc = "List topics" in
  let man = [
      `S Manpage.s_description;
      `P "List of topics" ]
  in
  let info = Cmd.info "topics" ~doc ~man in
  Cmd.v info topics_t
