open Logarion
module FS = File_store
module A = Archive

open Cmdliner
let recurse = Arg.(value & flag & info ["R"] ~doc: "Recurse into subdirectories")
let reverse = Arg.(value & flag & info ["r"] ~doc: "Reverse order")
let paths = Arg.(value & flag & info ["p"] ~doc: "Show file paths")
let number = Arg.(value & opt (some int) (Some 10) & info ["n"] ~docv: "number" ~doc: "Number of entries to list")
let authed = Arg.(value & opt (some string) None & info ["authored"] ~docv: "Comma-separated names" ~doc: "Texts by authors")
let topics = Arg.(value & opt (some string) None & info ["topics"] ~docv: "Comma-separated topics" ~doc: "Texts with topics")
let dir = Arg.(value & pos 0 string "" & info [] ~docv: "Directory to index")

let recent_t = Term.(const Listing.listing $ recurse $ (const true) $ reverse $ number $ paths $ authed $ topics $ dir)
let cmd =
  let doc = "List recent texts" in
  let man = [
      `S Manpage.s_description;
      `P "List header information of most recent texts.";
      `P "If -R is used, list header information for texts found in subdirectories, too, along with their filepaths" ]
  in
  let info = Cmd.info "recent" ~doc ~man in
  Cmd.v info recent_t
