let print_peers_of_peer p =
	let open Logarion.Header_pack in
	match Msgpck.to_list p.peers with [] -> ()
	| ps -> print_endline @@
		List.fold_left (fun a x -> Printf.sprintf "%s %s" a (Msgpck.to_string x)) "peers: " ps

type filter_t = { authors: Logarion.Person.Set.t; topics: Logarion.String_set.t }

let print_peer () peer =
	let open Logarion.Peers in
	Printf.printf "%s" peer.path;
	List.iter (Printf.printf "\t%s\n") peer.pack.info.locations

let remove_repo id =
	let repopath = Filename.concat Logarion.Peers.text_dir id in
	match Sys.is_directory repopath with
	| false -> Printf.eprintf "No repository %s in %s" id Logarion.Peers.text_dir
	| true ->
		let cmd = Printf.sprintf "rm -r %s" repopath in
		Printf.printf "Run: %s ? (y/N) %!" cmd;
		match input_char stdin with
		|'y'-> if Sys.command cmd = 0 then print_endline "Removed" else prerr_endline "Failed"
		| _ -> ()

let peers = function
	| Some id -> remove_repo id
	| None ->
		Printf.printf "Peers in %s\n" Logarion.Peers.text_dir;
		Logarion.Peers.fold print_peer ()

open Cmdliner
let remove = Arg.(value & opt (some string) None & info ["remove"] ~docv:"Repository ID" ~doc:"Remove repository texts and from future pulling")
let peers_t = Term.(const peers $ remove)

let cmd =
  let doc = "List current peers" in
  let man = [
      `S Manpage.s_description;
      `P "List current peers and associated information" ]
  in
  let info = Cmd.info "peers" ~doc ~man in
  Cmd.v info peers_t
