open Cmdliner
let id = Arg.(value & pos 0 string "" & info [] ~docv: "text ID")
let recurse = Arg.(value & flag & info ["R"] ~doc: "Recurse into subdirectories")
let reverse = Arg.(value & flag & info ["r"] ~doc: "Reverse order")
let time = Arg.(value & flag & info ["t"] ~doc: "Sort by time, newest first")
let number = Arg.(value & opt (some int) None & info ["n"] ~docv: "number" ~doc: "Number of entries to list")
let authed = Arg.(value & opt (some string) None & info ["authored"] ~docv: "Comma-separated names" ~doc: "Texts by authors")
let topics = Arg.(value & opt (some string) None & info ["topics"] ~docv: "Comma-separated topics" ~doc: "Texts by topics")

let edit_t = Term.(const (Logarion.Archive.apply_sys_util "EDITOR" "nano") $ recurse $ time $ reverse $ number $ authed $ topics $ id)

let cmd =
  let doc = "Edit a text" in
  let man = [
      `S Manpage.s_description;
      `P "Launches EDITOR (nano if environment variable is unset) with text path as parameter.";
      `P "If -R is used, the ID search space includes texts found in subdirectories, too.";
      `S Manpage.s_environment;
      `P "EDITOR - Default editor name" ]
  in
  let info = Cmd.info "edit" ~doc ~man in
  Cmd.v info edit_t
