open Logarion
let authors r topics_opt =
	let predicates = Archive.(predicate topics topics_opt) in
	let predicate text = List.fold_left (fun a e -> a && e text) true predicates in
	let author_union a (e, _) = Person.Set.union a e.Text.authors in
	let s = File_store.fold ~r ~predicate author_union Person.Set.empty in
	Person.Set.iter (fun x -> print_endline (Person.to_string x)) s

open Cmdliner
let recurse = Arg.(value & flag & info ["R"] ~doc: "Include texts in subdirectories too")
let topics = Arg.(value & opt (some string) None & info ["topics"] ~docv:"topics" ~doc: "Display authors who have written on topics")

let authors_t = Term.(const authors $ recurse $ topics)

let cmd =
  let doc = "List authors" in
  let man = [
      `S Manpage.s_description;
      `P "List author names" ]
  in
  let info = Cmd.info "authors" ~doc ~man in
  Cmd.v info authors_t
