let version = "1.3"

open Cmdliner
let default_cmd =
	let doc = "Discover, collect & exchange texts" in
	let man = [ `S "CONTACT"; `P "<mailto:logarion@lists.tildeverse.org?subject=Logarion>" ] in
	Term.(ret (const (`Help (`Pager, None)))), Term.info "txt" ~version ~doc ~man

let () = match Term.eval_choice default_cmd [
	Authors.term;
	Convert.term;
	Edit.term;
	File.term; File.unfile_term;
	Index.term;
	Last.term;
	Listing.term;
	New.term;
	Peers.term;
	Publish.term;
	Pull.term;
	Read.term;
	Recent.term;
	Topics.term;
	] with `Error _ -> exit 1 | _ -> exit 0
