let text_dir = Filename.concat (File_store.txtdir ()) "peers"

let fold fn init = match Sys.readdir text_dir with
	| exception (Sys_error msg) -> prerr_endline msg
	| dirs ->
		let read_pack path =
			let pack_path = Filename.(concat text_dir @@ concat path "index.pck") in
			match Sys.file_exists pack_path with false -> () | true ->
				match Header_pack.of_string (File_store.to_string pack_path) with
				| Error s -> Printf.eprintf "%s %s\n" s pack_path
				| Ok p -> ignore @@ List.fold_left fn init Header_pack.(p.info.locations)
		in
		Array.iter read_pack dirs

let scheme url =
	let colon_idx = String.index_from url 0 ':' in
	let scheme = String.sub url 0 colon_idx in
(*	let remain = String.(sub url (colon_idx+1) (length url - length scheme - 1)) in*)
	scheme
