let targets () =
	let kv = Logarion.File_store.of_kv_file () in
	let pub_dir =
		try Logarion.Store.KV.find "Pubdir" kv with Not_found ->
		try Sys.getenv "txtpubdir" with Not_found -> ""
	in
	let exists_dir dir = Sys.is_directory (Filename.concat pub_dir dir) in
	List.filter (fun x -> try exists_dir (snd x) with Sys_error _ -> false) [
		"htm,atom", "public_html/";
		"gmi,gmi-atom", "public_gemini/";
		"", "public_gopher/";
	]

open Logarion
let publish ids =
	let predicate t = List.mem t.Text.id ids in
	let targets = targets () in
	let pub_dirs = List.map (fun x -> snd x) targets in
	File_store.iter ~predicate (fun (_t, p) ->
		try File.file ((List.hd p)::pub_dirs)
		with Unix.Unix_error (Unix.EEXIST, _, _) -> ());
	List.iter (fun t -> Printf.eprintf "%s %s\n" (fst t) (snd t);
		Index.((load (snd t)) false None None None None);
		Convert.at_path (fst t) false (snd t);
		prerr_endline (snd t))
		targets

open Cmdliner
let term =
	let ids = Arg.(value & pos_all string [] & info [] ~docv:"text ids") in
	let doc = "convert texts into standard public dirs public_{html,gemini,gopher} if they exist" in
	Term.(const publish $ ids), Term.info "publish" ~doc ~man:[ `S "DESCRIPTION"; `P doc ]
