//go:build !nogcss
// Render .gcss files into .css
package main

import (
	"io"
	"os"
	"path/filepath"
	"strings"
	"github.com/yosssi/gcss"
)

func buildGCSS(path string, w io.Writer) error {
        f, err := os.Open(path)
        if err != nil {
                return err
        }
        defer f.Close()

        if w == nil {
                s := strings.TrimSuffix(path, ".gcss") + ".css"
                css, err := os.Create(filepath.Join(PUBDIR, s))
                if err != nil {
                        return err
                }
                defer css.Close()
                w = css
        }
        _, err = gcss.Compile(w, f)
        return err
}
