//go:build !noamber
// Render .amber files into .html
package main

import (
	"bytes"
	"fmt"
	"io"
	"os"
	"path/filepath"
	"github.com/eknkc/amber"
)

func buildAmber(path string, w io.Writer, vars Vars) error {
        v, body, err := getVars(path, vars)
        if err != nil {
                return err
        }
        a := amber.New()
        if err := a.Parse(body); err != nil {
                fmt.Println(body)
                return err
        }

        t, err := a.Compile()
        if err != nil {
                return err
        }

        htmlBuf := &bytes.Buffer{}
        if err := t.Execute(htmlBuf, v); err != nil {
                return err
        }

        if body, err = render(string(htmlBuf.Bytes()), v); err != nil {
                return err
        }
        if w == nil {
                f, err := os.Create(filepath.Join(PUBDIR, renameExt(path, ".amber", ".html")))
                if err != nil {
                        return err
                }
                defer f.Close()
                w = f
        }
        _, err = io.WriteString(w, body)
        return err
}
