# aya

aya is an extremely minimal static site generator written in Go.

Named after [Aya Shameimaru](https://en.touhouwiki.net/wiki/Aya_Shameimaru) from [Touhou 9.5: Shoot the Bullet](https://en.touhouwiki.net/wiki/Shoot_the_Bullet)

## Features

* Zero configuration (no configuration file needed)
* Cross-platform
* Highly extensible
* Works well for blogs and generic static websites (landing pages etc)
* Easy to learn (you literally don't need to)
* Fast (goes without saying)

## Installation

Build it manually provided you have Go (>=1.17) installed:

	$ go install marisa.chaotic.ninja/aya/cmd/aya@latest (1)
	--- or ---
	$ git clone https://git.chaotic.ninja/yakumo_izuru/aya
	$ cd aya
	$ make
	# make install

(1) If you use this method, the `aya version` subcommand may print the wrong string,
but it should not be a problem unless you use it on a page.

You can also disable certain features at build time, with the `-tags` switch.
Currently, these tags are available: `noamber`, `nogcss`.
See `go help buildconstraint` for more details.

## Ideology

Keep your texts in markdown, [amber](https://github.com/eknkc/amber), or html format right in the main directory
of your blog/site.

Keep all service files (extensions, layout pages, deployment scripts etc)
in the `.aya` subdirectory.

Define variables in the header of the content files using [YAML](https://noyaml.com) :

```markdown
title: My web site
keywords: best website, hello, world
---

Markdown text goes after a header *separator*
```

Use placeholders for variables and plugins in your markdown or html
files, e.g. `{{ title }}` or `{{ command arg1 arg2 }}.

Write extensions in any language you like and put them into the `.aya`
subdiretory.

Everything the extensions prints to [stdout](https://man.freebsd.org/cgi/man.cgi?fd) becomes the value of the
placeholder.

Every variable from the content header will be passed via environment variables like `title` becomes `$AYA_TITLE` and so on. 
There are some special variables:

* `$AYA` - a path to the `aya` executable
* `$AYA_OUTDIR` - a path to the directory with generated files
* `$AYA_FILE` - a path to the currently processed markdown file
* `$AYA_URL` - a URL for the currently generated page

## Example of RSS generation

Extensions can be written in any language you know (Bash, Python, Lua, JavaScript, Go, even Assembler). Here's an example of how to scan all markdown blog posts and create RSS items:

``` bash
#!/bin/sh
echo "Generating RSS feed"

echo '<?xml version="1.0" encoding="utf-8"?>' > $AYA_OUTDIR/blog/rss.xml
echo '<rss version="2.0" xmlns:content="http://purl.org/rss/1.0/modules/content/">' >> $AYA_OUTDIR/blog/rss.xml
echo '<channel>' >> $AYA_OUTDIR/blog/rss.xml
for f in ./blog/*/*.md ; do
    d=$($AYA var $f date)
    if [ ! -z $d ] ; then
        timestamp=`gdate --date "$d" +%s`
        url=`$AYA var $f url`
        title=`$AYA var $f title | tr A-Z a-z`
        descr=`$AYA var $f description`
        echo $timestamp "<item><title>$title</title><link>https://technicalmarisa.chaotic.ninja/blog/$url</link><description>$descr</description><pubDate>$(gdate --date @$timestamp -R)</pubDate><guid>http://technicalmarisa.chaotic.ninja/blog/$url</guid></item>"
    fi
done | sort -r -n | cut -d' ' -f2- >> $AYA_OUTDIR/blog/rss.xml
echo '</channel>' >> $AYA_OUTDIR/blog/rss.xml
echo '</rss>' >> $AYA_OUTDIR/blog/rss.xml
```

## Hooks
There are two special plugin names that are executed every time the build
happens - `prehook` and `posthook`. You can define some global actions here like
content generation, or additional commands, like LESS to CSS conversion

Note, you can also place `.gcss` files for [gcss](https://github.com/yosssi/gcss) to process instead

## Command line usage
Read `aya(1)`

## License
The software is distributed under the [MIT/X11](LICENSE) license.

## Sites using Aya!
(I know, I made the majority of them, but they still count)

| Title                  | Author                                           | Link                                  |
|------------------------|--------------------------------------------------|---------------------------------------|
| Aya (project homepage) | Izuru Yakumo                                     | https://aya.chaotic.ninja             |
| Chaotic Ninja          | Izuru Yakumo, Mima-sama                          | https://chaotic.ninja                 |
| Geidontei              | Izuru Yakumo                                     | https://geidontei.chaotic.ninja       |
| ChaoticIRC Network     | Izuru Yakumo                                     | https://im.chaotic.ninja              |
| Kanako                 | Izuru Yakumo                                     | https://kanako.chaotic.ninja          |
| Kill-9 The Revival     | Various authors                                  | https://kill-9.chaotic.ninja          |
| PXIMG(7)               | Izuru Yakumo                                     | https://pximg.chaotic.ninja           |
| Shinmyoumaru           | Mima-sama                                        | https://shinmyoumaru.chaotic.ninja    |
| Suika                  | Izuru Yakumo                                     | https://suika.chaotic.ninja           |
| TechnicalMarisa        | Izuru Yakumo                                     | https://technicalmarisa.chaotic.ninja |
| Tengu Space            | [DeviousTengu](https://fedi.tengu.space/devious) | https://tengu.space                   |
| WindowMaker Shrine     | Izuru Yakumo                                     | https://themes.chaotic.ninja          |

---

Ayaya~
