// This is used for setting build-time variables
package aya

import (
	"fmt"
)

var (
	// Variables set at build-time
	Date string
	Vendor string
	Version string
)

// PrintVersion only displays the obvious
func PrintVersion() string {
	return fmt.Sprintf("%s", Version)
}

// PrintFullVersion display the full version and build
func PrintFullVersion() string {
	return fmt.Sprintf("%s, built at %s, on %s", Version, Date, Vendor)
}
