// run() executes a command or a script. 
// Vars define the command environment, each aya var is converted into OS environment variable with AYA_ prefix prepended.
// Additional variable $AYA contains path to the aya binary.
// Command stderr(4) is printed to aya stderr(4), command stdout(4) is returned as a string
package main

import (
	"bytes"
	"fmt"
	"os"
	"os/exec"
	"path/filepath"
	"strings"
)

func run(vars Vars, cmd string, args ...string) (string, error) {
        // First check if partial exists (.html)
        if b, err := os.ReadFile(filepath.Join(AYADIR, cmd+".html")); err == nil {
                return string(b), nil
        }

        var errbuf, outbuf bytes.Buffer
        c := exec.Command(cmd, args...)
        env := []string{"AYA=" + os.Args[0], "AYA_OUTDIR=" + PUBDIR}
        env = append(env, os.Environ()...)
        for k, v := range vars {
                env = append(env, "AYA_"+strings.ToUpper(k)+"="+v)
        }
        c.Env = env
        c.Stdout = &outbuf
        c.Stderr = &errbuf

        err := c.Run()

        if errbuf.Len() > 0 {
                fmt.Println("ERROR:", errbuf.String())
        }
        if err != nil {
                return "", err
        }
        return string(outbuf.Bytes()), nil
}
