// Render expanding aya plugins and variables
package main

import (
	"bytes"
	"fmt"
	"strings"
)

func render(s string, vars Vars) (string, error) {
        delimOpen := "{{"
        delimClose := "}}"

        out := &bytes.Buffer{}
        for {
                if from := strings.Index(s, delimOpen); from == -1 {
                        out.WriteString(s)
                        return out.String(), nil
                } else {
                        if to := strings.Index(s, delimClose); to == -1 {
                                return "", fmt.Errorf("Closing delimiter not found")
                        } else {
                                out.WriteString(s[:from])
                                cmd := s[from+len(delimOpen) : to]
                                s = s[to+len(delimClose):]
                                m := strings.Fields(cmd)
                                if len(m) == 1 {
                                        if v, ok := vars[m[0]]; ok {
                                                out.WriteString(v)
                                                continue
                                        }
                                }
                                if res, err := run(vars, m[0], m[1:]...); err == nil {
                                        out.WriteString(res)
                                } else {
                                        fmt.Println(err)
                                }
                        }
                }
        }

}
