// renameExt renames extension (if any) from oldext to newext
// If oldext is an empty string - extension is extracted automatically.
// If path has no extension - new extension is appended
package main

import (
	"path/filepath"
	"strings"
)

func renameExt(path, oldext, newext string) string {
        if oldext == "" {
                oldext = filepath.Ext(path)
        }
        if oldext == "" || strings.HasSuffix(path, oldext) {
                return strings.TrimSuffix(path, oldext) + newext
        }
        return path
}
