// $TheSupernovaDuo: marisa.chaotic.ninja/aya/cmd/aya, v1.0.0 2023-12-12 13:44:23+0000, yakumo_izuru Exp $
package main

import (
	"fmt"
	"os"
	"strings"

	"marisa.chaotic.ninja/aya"
)

// Define global constants here
const (
	AYADIR = ".aya"
	PUBDIR = ".pub"
)

type Vars map[string]string

// Initialize the environment
func init() {
	// prepend .aya to $PATH, so plugins will be found before OS commands
	p := os.Getenv("PATH")
	p = os.Getenv("PWD") + "/" + AYADIR + ":" + p
	os.Setenv("PATH", p)
}

// Main loop
func main() {
	if len(os.Args) == 1 {
		fmt.Println("No command supplied. See 'aya help'")
		os.Exit(1)
	}
	cmd := os.Args[1]
	args := os.Args[2:]
	switch cmd {
	case "build":
		if len(args) == 0 {
			buildAll(false)
		} else if len(args) == 1 {
			if err := build(args[0], os.Stdout, globals()); err != nil {
				fmt.Println("ERROR: " + err.Error())
				os.Exit(1)
			}
		} else {
			fmt.Println("ERROR: too many arguments")
			os.Exit(1)
		}
	case "clean":
		fmt.Println("Removing generated site directory")
		os.RemoveAll(PUBDIR)
	case "help":
		aya.PrintUsage()
	case "serve":
		aya.HttpServe(PUBDIR, 8000)
	case "var":
		if len(args) == 0 {
			fmt.Println("var: filename expected")
			os.Exit(1)
		} else {
			s := ""
			if vars, _, err := getVars(args[0], Vars{}); err != nil {
				fmt.Println("var: " + err.Error())
			} else {
				if len(args) > 1 {
					for _, a := range args[1:] {
						s = s + vars[a] + "\n"
					}
				} else {
					for k, v := range vars {
						s = s + k + ":" + v + "\n"
					}
				}
			}
			fmt.Println(strings.TrimSpace(s))
		}
	case "version":
		fmt.Printf("%v\n", aya.PrintVersion())
		os.Exit(0)
	case "watch":
		buildAll(true)
	default:
		if s, err := run(globals(), cmd, args...); err != nil {
			fmt.Println(err)
		} else {
			fmt.Println(s)
		}
	}
}
