// globals returns list of global OS environment variables that start
// with AYA_ prefix as Vars, so the values can be used inside templates
package main

import (
	"os"
	"strings"
)

func globals() Vars {
        vars := Vars{}
        for _, e := range os.Environ() {
                pair := strings.Split(e, "=")
                if strings.HasPrefix(pair[0], "AYA_") {
                        vars[strings.ToLower(pair[0][3:])] = pair[1]
                }
        }
        return vars
}
