// This function passes the files to build to their corresponding functions
// As far as I'm aware, Markdown has three possible filename extensions,
// but .md is the most common one known.
package main

import (
	"io"
	"path/filepath"
)
func build(path string, w io.Writer, vars Vars) error {
        ext := filepath.Ext(path)
        if ext == ".md" || ext == ".mkd" || ext == ".markdown" {
                return buildMarkdown(path, w, vars)
        } else if ext == ".htm" || ext == ".html" || ext == ".xht" || ext == ".xhtml" {
                return buildHTML(path, w, vars)
        } else if ext == ".amber" {
                return buildAmber(path, w, vars)
        } else if ext == ".gcss" {
                return buildGCSS(path, w)
        } else {
                return buildRaw(path, w)
        }
}
