// This is used for setting build-time variables
package aya

import (
	"fmt"
	"time"
)

var (
	// Set to current tag
	Version = "v0.7.0"
	Time = time.Now()
)

// FullVersion display the full version and build
func FullVersion() string {
	d := Time.Day()
	m := Time.Month()
	y := Time.Year()
	return fmt.Sprintf("%v || %d.%d.%d", Version, y, m, d)
}
