// Copy files as-is from source to destination
package main

import (
	"io"
	"os"
	"path/filepath"
)

func buildRaw(path string, w io.Writer) error {
        in, err := os.Open(path)
        if err != nil {
                return err
        }
        defer in.Close()
        if w == nil {
                if out, err := os.Create(filepath.Join(PUBDIR, path)); err != nil {
                        return err
                } else {
                        defer out.Close()
                        w = out
                }
        }
        _, err = io.Copy(w, in)
        return err
}
