// Renders markdown with the given layout into html expanding all the macros
package main

import (
	"io"
	"os"
	"path/filepath"
	"github.com/russross/blackfriday/v2"
)

func buildMarkdown(path string, w io.Writer, vars Vars) error {
        v, body, err := getVars(path, vars)
        extensions := blackfriday.CommonExtensions|blackfriday.AutoHeadingIDs|blackfriday.Strikethrough|blackfriday.Footnotes
        if err != nil {
                return err
        }
        content, err := render(body, v)
        if err != nil {
                return err
        }
        v["content"] = string(blackfriday.Run([]byte(content),
                blackfriday.WithExtensions(extensions),
        ))
        if w == nil {
                out, err := os.Create(filepath.Join(PUBDIR, renameExt(path, "", ".html")))
                if err != nil {
                        return err
                }
                defer out.Close()
                w = out
        }
        return buildHTML(filepath.Join(AYADIR, v["layout"]), w, v)
}
