// Renders hypertext files expanding all variable macros inside it
package main

import (
	"io"
	"os"
	"path/filepath"
	"text/template"
)

func buildHTML(path string, w io.Writer, vars Vars) error {
        v, body, err := getVars(path, vars)
        if err != nil {
                return err
        }
        if body, err = render(body, v); err != nil {
                return err
        }
        tmpl, err := template.New("").Delims("<%", "%>").Parse(body)
        if err != nil {
                return err
        }
        if w == nil {
                f, err := os.Create(filepath.Join(PUBDIR, path))
                if err != nil {
                        return err
                }
                defer f.Close()
                w = f
        }
        return tmpl.Execute(w, vars)
}
