# aya

aya is an extremely minimal static site generator written in Go.

This crow tengu stands for 'the fastest one in Gensokyo' and yes this is also a Touhou Project reference.

## Features

* Zero configuration (no configuration file needed)
* Cross-platform
* Highly extensible
* Works well for blogs and generic static websites (landing pages etc)
* Easy to learn
* Fast

## Installation

Build it manually assuming you have Go installed:

	$ go install marisa.chaotic.ninja/aya/cmd/aya@latest

## Ideology

Keep your texts in markdown, or HTML format right in the main directory
of your blog/site.

Keep all service files (extensions, layout pages, deployment scripts etc)
in the `.aya` subdirectory.

Define variables in the header of the content files using [YAML]:

	title: My web site
	keywords: best website, hello, world
	---

	Markdown text goes after a header *separator*

Use placeholders for variables and plugins in your markdown or html
files, e.g. `{{ title }}` or `{{ command arg1 arg2 }}.

Write extensions in any language you like and put them into the `.aya`
subdiretory.

Everything the extensions prints to stdout becomes the value of the
placeholder.

Every variable from the content header will be passed via environment variables like `title` becomes `$AYA_TITLE` and so on. There are some special variables:

* `$AYA` - a path to the `aya` executable
* `$AYA_OUTDIR` - a path to the directory with generated files
* `$AYA_FILE` - a path to the currently processed markdown file
* `$AYA_URL` - a URL for the currently generated page

## Example of RSS generation

Extensions can be written in any language you know (Bash, Python, Lua, JavaScript, Go, even Assembler). Here's an example of how to scan all markdown blog posts and create RSS items:

``` bash
for f in ./blog/*.md ; do
	d=$($AYA var $f date)
	if [ ! -z $d ] ; then
		timestamp=`date --date "$d" +%s`
		url=`$AYA var $f url`
		title=`$AYA var $f title | tr A-Z a-z`
		descr=`$AYA var $f description`
		echo $timestamp \
			"<item>" \
			"<title>$title</title>" \
			"<link>http://zserge.com/$url</link>" \
			"<description>$descr</description>" \
			"<pubDate>$(date --date @$timestamp -R)</pubDate>" \
			"<guid>http://zserge.com/$url</guid>" \
		"</item>"
	fi
done | sort -r -n | cut -d' ' -f2-
```

## Hooks

There are two special plugin names that are executed every time the build
happens - `prehook` and `posthook`. You can define some global actions here like
content generation, or additional commands, like LESS to CSS conversion:

	# .aya/post

	#!/bin/sh
	lessc < $AYA_OUTDIR/styles.less > $AYA_OUTDIR/styles.css
	rm -f $AYA_OUTDIR/styles.css

## Command line usage

`aya build` re-builds your site.

`aya build <file>` re-builds one file and prints resulting content to stdout.

`aya serve` serves your site over HTTP.

`aya var <filename> [var1 var2...]` prints a list of variables defined in the
header of a given markdown file, or the values of certain variables (even if
it's an empty string).

`aya watch` rebuilds your site every time you modify any file. 

## License

The software is distributed under the MIT license.
